//*********************************************************************************
//**
//** Platform........: ATMEL ATmega or AT90 series of Microcontrollers
//**
//** Licence.........: This software is freely available for non-commercial 
//**                   use only - i.e. for research and experimentation.
//**
//**                   Simple USART Receive functions, copy/pasted out of
//**                   the AT90USB128 datasheet (Atmel doc7593.pdf)
//**
//**
//**                   2012-10-21, Loftur Jonasson, TF3LJ
//**
//*********************************************************************************


#include <avr/io.h>
#include "ML.h"

void usart_Init(void)
{
	// Set baud rate
	UBRR1 = (unsigned char)BAUD;

	// Enable receiver and transmitter
	UCSR1B = (1<<RXEN1)|(1<<TXEN1);

	// Set frame format: 8data, 1stop bit
	UCSR1C = 3<<UCSZ10;
}

//
// Checks USART for a received char, returns 0xff if nothing received
//
uint8_t usart_Receive(void)
{
	// Return received char if any
	if ( UCSR1A & (1<<RXC1) ) return UDR1;

	// Nothing received
	else return 0xff;
}
